/*
-----------------------------------------------------------------------------
This source file is part of OGRE
(Object-oriented Graphics Rendering Engine)
For the latest info, see http://www.ogre3d.org

Copyright (c) 2000-2013 Torus Knot Software Ltd
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
-----------------------------------------------------------------------------
*/

//-----------------------------------------------------------------------------
// Program Name: FFPLib_Common
// Program Desc: Common functions of the FFP.
// Program Type: Vertex/Pixel shader
// Language: HLSL
// Notes: Common functions needed by all FFP implementation classes.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
void FFP_Assign(in float vIn, out float vOut)
{
	vOut = vIn;
}
//-----------------------------------------------------------------------------
void FFP_Assign(in float2 vIn, out float2 vOut)
{
	vOut = vIn;
}

//-----------------------------------------------------------------------------
void FFP_Assign(in float3 vIn, out float3 vOut)
{
	vOut = vIn;
}

//-----------------------------------------------------------------------------
void FFP_Assign(in float4 vIn, out float4 vOut)
{
	vOut = vIn;
}

//-----------------------------------------------------------------------------
void FFP_Construct(in float r, 
				   in float g,
				   in float b,
				   in float a,
				   out float4 vOut)
{
	vOut = float4(r,g,b,a);
}

//-----------------------------------------------------------------------------
void FFP_Construct(in float r, 
			 in float g,
			 out float2 vOut)
{
	vOut = float2(r,g);
}

//-----------------------------------------------------------------------------
void FFP_Construct(in float r, 
				   in float g,
				   in float b,
				   out float3 vOut)
{
	vOut = float3(r,g,b);
}

//-----------------------------------------------------------------------------
void FFP_Construct(in float r, 				   
				   out float4 vOut)
{
	vOut = float4(r,r,r,r);
}

//-----------------------------------------------------------------------------
void FFP_Modulate(in float vIn0, in float vIn1, out float vOut)
{
	vOut = vIn0 * vIn1;
}

//-----------------------------------------------------------------------------
void FFP_Modulate(in float2 vIn0, in float2 vIn1, out float2 vOut)
{
	vOut = vIn0 * vIn1;
}

//-----------------------------------------------------------------------------
void FFP_Modulate(in float3 vIn0, in float3 vIn1, out float3 vOut)
{
	vOut = vIn0 * vIn1;
}

//-----------------------------------------------------------------------------
void FFP_Modulate(in float4 vIn0, in float4 vIn1, out float4 vOut)
{
	vOut = vIn0 * vIn1;
}

//-----------------------------------------------------------------------------
void FFP_Add(in float vIn0, in float vIn1, out float vOut)
{
	vOut = vIn0 + vIn1;
}

//-----------------------------------------------------------------------------
void FFP_Add(in float2 vIn0, in float2 vIn1, out float2 vOut)
{
	vOut = vIn0 + vIn1;
}

//-----------------------------------------------------------------------------
void FFP_Add(in float3 vIn0, in float3 vIn1, out float3 vOut)
{
	vOut = vIn0 + vIn1;
}

//-----------------------------------------------------------------------------
void FFP_Add(in float4 vIn0, in float4 vIn1, out float4 vOut)
{
	vOut = vIn0 + vIn1;
}

//-----------------------------------------------------------------------------
void FFP_Subtract(in float vIn0, in float vIn1, out float vOut)
{
	vOut = vIn0 - vIn1;
}

//-----------------------------------------------------------------------------
void FFP_Subtract(in float2 vIn0, in float2 vIn1, out float2 vOut)
{
	vOut = vIn0 - vIn1;
}

//-----------------------------------------------------------------------------
void FFP_Subtract(in float3 vIn0, in float3 vIn1, out float3 vOut)
{
	vOut = vIn0 - vIn1;
}

//-----------------------------------------------------------------------------
void FFP_Subtract(in float4 vIn0, in float4 vIn1, out float4 vOut)
{
	vOut = vIn0 - vIn1;
}

//-----------------------------------------------------------------------------
void FFP_Lerp(in float vIn0, in float vIn1, float T, out float vOut)
{
	vOut = lerp(vIn0, vIn1, T);
}

//-----------------------------------------------------------------------------
void FFP_Lerp(in float2 vIn0, in float2 vIn1, float T, out float2 vOut)
{
	vOut = lerp(vIn0, vIn1, T);
}

//-----------------------------------------------------------------------------
void FFP_Lerp(in float3 vIn0, in float3 vIn1, float T, out float3 vOut)
{
	vOut = lerp(vIn0, vIn1, T);
}

//-----------------------------------------------------------------------------
void FFP_Lerp(in float4 vIn0, in float4 vIn1, float T, out float4 vOut)
{
	vOut = lerp(vIn0, vIn1, T);
}

//-----------------------------------------------------------------------------
void FFP_Lerp(in float4 vIn0, in float4 vIn1, float4 T, out float4 vOut)
{
	vOut = lerp(vIn0, vIn1, T);
}

//-----------------------------------------------------------------------------
void FFP_DotProduct(in float vIn0, in float vIn1, out float vOut)
{
	vOut = dot(vIn0, vIn1);
}

//-----------------------------------------------------------------------------
void FFP_DotProduct(in float2 vIn0, in float2 vIn1, out float2 vOut)
{
	vOut = dot(vIn0, vIn1);
}

//-----------------------------------------------------------------------------
void FFP_DotProduct(in float3 vIn0, in float3 vIn1, out float3 vOut)
{
	vOut = dot(vIn0, vIn1);
}

//-----------------------------------------------------------------------------
void FFP_DotProduct(in float4 vIn0, in float4 vIn1, out float4 vOut)
{
	vOut = dot(vIn0, vIn1);
}



